<?php
session_start();
error_reporting(E_ALL);
include("../config/dbconfig.php");

$query = "SELECT * FROM system_settings";
$result = mysqli_query($con, $query);
if ($result) {
    $row = mysqli_fetch_assoc($result);
    $bname = $row['bank_name'];
} else {
    die("Error fetching system settings: " . mysqli_error($con));
}

$m = date("Y-m-d");

if (isset($_POST["button"])) {

    $stmt = $con->prepare("SELECT * FROM customers WHERE loginid = ?");
    $stmt->bind_param("s", $_POST['loginid']);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $logmsg = "<script>swal('Error!', 'Login ID already exists!', 'error')</script>";
    } else {

        $stmt = $con->prepare("INSERT INTO customers (accountno, cot, imf, phone, email, acctype, ifsccode, firstname, lastname, loginid, accpassword, transpassword, accstatus, country, state, city, accopendate) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'Active', ?, ?, ?, ?)");
        $stmt->bind_param("ssssssssssssssss", $_POST['acc'], $_POST['cot'], $_POST['imf'], $_POST['phone'], $_POST['email'], $_POST['acctype'], $_POST['brname'], $_POST['firstname'], $_POST['lastname'], $_POST['loginid'], $_POST['accountpassword'], $_POST['transactionpassword'], $_POST['country'], $_POST['state'], $_POST['city'], $m);

        if ($stmt->execute()) {

            $stmt = $con->prepare("SELECT customerid FROM customers WHERE loginid = ?");
            $stmt->bind_param("s", $_POST['loginid']);
            $stmt->execute();
            $result = $stmt->get_result();
            $arra = $result->fetch_assoc();
            $cusid = $arra['customerid'];


            $stmt = $con->prepare("INSERT INTO accounts (accno, customerid, accstatus, accopendate, accounttype, accountbalance) VALUES (?, ?, ?, ?, ?, 0)");
            $stmt->bind_param("sssss", $_POST['acc'], $cusid, $_POST['accstatus'], $m, $_POST['acctype']);
            $stmt->execute();

            $subj = 'Welcome To Our Bank';
            $mess = 'We welcome you to our online banking platform as we hope to serve you better. Your login Id is ' . htmlspecialchars($_POST['loginid']) . ', your account password is ' . htmlspecialchars($_POST['accountpassword']) . ' and your transaction password is ' . htmlspecialchars($_POST['transactionpassword']) . '. Please feel free to change it any time';
            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            $headers .= 'From: <no-reply@' . $bname . '>' . "\r\n";
            $to = $_POST['email'];
            mail($to, $subj, $mess, $headers);

            $logmsg = "<script>swal('Successful!', 'Your account has been created and a mail containing your account login details has been sent to you. Your Account Number is " . htmlspecialchars($_POST['acc']) . ". Thank you for joining us!', 'success')</script>";
        } else {
            die('Error: ' . mysqli_error($con));
        }
    }
    $stmt->close();
}

$result = mysqli_query($con, "SELECT * FROM branch");
if (!$result) {
    die("Error fetching branches: " . mysqli_error($con));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Khaytech Banking System">
    <meta name="keywords" content="Banking, Online, Piggybank">
    <title>Customers Login</title>

    <!-- Site favicon -->
    <link rel="shortcut icon" href="../assets/images/favicon.ico" type="image/x-icon">
    <!-- Font Icon Styles -->
    <link rel="stylesheet" href="../assets/node_modules/flag-icon-css/css/flag-icon.min.css">
    <link rel="stylesheet" href="../assets/vendors/gaxon-icon/styles.css">
    <!-- Perfect Scrollbar stylesheet -->
    <link rel="stylesheet" href="../assets/node_modules/perfect-scrollbar/css/perfect-scrollbar.css">
    <!-- Load Styles -->
    <link rel="stylesheet" href="../assets/css/light-style-1.min.css">
</head>
<body class="dt-sidebar--fixed dt-header--fixed">
    <!-- Loader -->
    <div class="dt-loader-container">
        <div class="dt-loader">
            <svg class="circular" viewBox="25 25 50 50">
                <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"></circle>
            </svg>
        </div>
    </div>
    <!-- Root -->
    <div class="dt-root">
        <div class="dt-root__inner">
            <!-- Login Container -->
            <div class="dt-login--container">
                <!-- Login Content -->
                <div class="dt-login__content-wrapper">
                    <!-- Login Background Section -->
                    <div class="dt-login__bg-section">
                        <div class="dt-login__bg-content">
                            <h1 class="dt-login__title">Create An Account</h1>
                            <p class="f-16">Create an account with us to explore the possibilities of online banking.</p>
                        </div>
                        <!-- Brand logo -->
                        <div class="dt-login__logo">
                            <a class="dt-brand__logo-link" href="login.php">
                                <img class="dt-brand__logo-img" src="../assets/images/logoo.png" alt="Drift">
                            </a>
                        </div>
                    </div>
                    <!-- Login Content Section -->
                    <div class="dt-login__content">
                        <div class="dt-login__content-inner">
                            <!-- Form -->
                            <form onsubmit="return valid()" id="form1" name="form1" method="post" action="">
                                <p><?php echo $logmsg; ?></p>
                                <!-- Grid -->
                                <div class="row">
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Customer's First Name</label>
                                            <input required name="firstname" id="firstname" class="form-control">
                                        </div>
                                    </div>
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Customer's Last Name</label>
                                            <input type="text" name="lastname" id="lastname" class="form-control">
                                        </div>
                                    </div>
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Customer's Phone</label>
                                            <input type="number" name="phone" class="form-control">
                                        </div>
                                    </div>
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Customer's Email</label>
                                            <input type="email" name="email" class="form-control">
                                        </div>
                                    </div>
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Select Country</label>
                                            <select name="country" id="country" class="custom-select custom-select-sm">
                                                <option value="">Select</option>

                                                <option value="Afghanistan">Afghanistan</option>

                                            </select>
                                        </div>
                                    </div>
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Enter State</label>
                                            <input name="state" id="state" class="form-control">
                                        </div>
                                    </div>
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Enter City</label>
                                            <input name="city" id="city" class="form-control">
                                        </div>
                                    hôn: <input hidden required type="number" readonly value="<?php echo $tcode; ?>" name="acc" class="form-control">
                                    </div>
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Login ID</label>
                                            <input required name="loginid" value="<?php echo $loginid; ?>" id="loginid" class="form-control">
                                        </div>
                                    </div>
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Login Password</label>
                                            <input required type="text" value="<?php echo $loginpass; ?>" name="accountpassword" id="accountpassword" class="form-control">
                                            <input required type="text" value="<?php echo $cot; ?>" hidden name="imf" id="accountpassword" class="form-control">
                                            <input required type="text" value="<?php echo $imf; ?>" hidden name="cot" id="accountpassword" class="form-control">
                                        </div>
                                    </div>
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Transaction Password</label>
                                            <input required type="text" value="<?php echo $loginpass; ?>" name="transactionpassword" id="transactionpassword" class="form-control">
                                        </div>
                                    </div>
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Select Bank Branch</label>
                                            <select name="brname" id="brname" class="custom-select custom-select-sm">
                                                <?php
                                                while ($rta = mysqli_fetch_assoc($result)) {
                                                    echo "<option value='" . htmlspecialchars($rta['ifsccode']) . "'>" . htmlspecialchars($rta['branchname']) . "</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                    <!-- Grid Item -->
                                    <div class="col-sm-6">
                                        <div class="form-group">
                                            <label>Select Account Type</label>
                                            <select name="acctype" class="custom-select custom-select-sm">
                                                <?php
                                                $re = mysqli_query($con, "SELECT * FROM accountmaster");
                                                while ($a = mysqli_fetch_assoc($re)) {
                                                    echo "<option value='" . htmlspecialchars($a['accounttype']) . "'>" . htmlspecialchars($a['accounttype']) . "</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <!-- /grid -->
                                <!-- Card Footer -->
                                <div class="px-7 py-5 border-top border-width-2 border-black-transparent">
                                    <div align="right">
                                        <input type="submit" name="button" id="button" class="btn btn-secondary" value="Open Account" />
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Optional JavaScript -->
    <script src="../assets/node_modules/jquery/dist/jquery.min.js"></script>
    <script src="../assets/node_modules/moment/moment.js"></script>
    <script src="../assets/node_modules/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/node_modules/perfect-scrollbar/dist/perfect-scrollbar.min.js"></script>
    <script src="../assets/node_modules/masonry-layout/dist/masonry.pkgd.min.js"></script>
    <script src="../assets/node_modules/sweetalert2/dist/sweetalert2.js"></script>
    <script src="../assets/js/functions.js"></script>
    <script src="../assets/js/customizer.js"></script>
    <script src="../assets/js/script.js"></script>
    <script src="../assets/js/custom/sweet-alert.js"></script>
</body>
</html>
<?php include 'footer.php'; ?>