<?php
session_start();
include("../config/dbconfig.php");

if (!$con) {
    die("Connection failed: " . mysqli_connect_error());
}


if (isset($_SESSION['adminid'])) {
    header("Location: dashboard.php");
    exit();
}


$logininfo = "";

if (isset($_POST['go'])) {
    $username = $_POST['login'];
    $password = $_POST['password'];

 
    error_log("Username: $username, Password: $password");


    $stmt = $con->prepare("SELECT id, username, password FROM administrator WHERE username = ?");
    if (!$stmt) {
        die("Prepare failed: " . $con->error);
    }
    $stmt->bind_param("s", $username);
    $stmt->execute();
    

    $stmt->bind_result($id, $db_username, $db_password);
    
    if ($stmt->fetch()) {

        error_log("Stored password: $db_password");


        if ($password === $db_password) { 

            $_SESSION['adminid'] = $id;
            $_SESSION['admin_username'] = $db_username;
            error_log("Login successful, redirecting to admindashboard.php");
            header("Location: admindashboard.php");
            exit();
        } else {
            $logininfo = "<script>swal('Error!', 'Wrong Username or Password Entered!', 'error')</script>";
            error_log("Password mismatch");
        }
    } else {
        $logininfo = "<script>swal('Error!', 'Wrong Username or Password Entered!', 'error')</script>";
        error_log("No user found with username: $username");
    }
    $stmt->close();
} else {
    error_log("Form not submitted or 'go' not set");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Khaytech Banking System">
    <meta name="keywords" content="Banking, Online, Piggybank">
    <title>Admin Login</title>

    <!-- Site favicon -->
    <link rel="shortcut icon" href="../assets/images/favicon.ico" type="image/x-icon">
    <!-- Font Icon Styles -->
    <link rel="stylesheet" href="../assets/node_modules/flag-icon-css/css/flag-icon.min.css">
    <link rel="stylesheet" href="../assets/vendors/gaxon-icon/styles.css">
    <!-- Perfect Scrollbar stylesheet -->
    <link rel="stylesheet" href="../assets/node_modules/perfect-scrollbar/css/perfect-scrollbar.css">
    <!-- Load Styles -->
    <link rel="stylesheet" href="../assets/css/light-style-1.min.css">
</head>
<body class="dt-sidebar--fixed dt-header--fixed">
    <!-- Loader -->
    <div class="dt-loader-container">
        <div class="dt-loader">
            <svg class="circular" viewBox="25 25 50 50">
                <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"></circle>
            </svg>
        </div>
    </div>
    <!-- Root -->
    <div class="dt-root">
        <div class="dt-root__inner">
            <!-- Login Container -->
            <div class="dt-login--container">
                <!-- Login Content -->
                <div class="dt-login__content-wrapper">
                    <!-- Login Background Section -->
                    <div class="dt-login__bg-section">
                        <div class="dt-login__bg-content">
                            <h1 class="dt-login__title">Admin Login</h1>
                            <p class="f-16">Welcome Administrator.</p>
                            <?php echo $logininfo; ?>
                        </div>
                        <!-- Brand logo -->
                        <div class="dt-login__logo">
                            <a class="dt-brand__logo-link" href="login.php">
                                <img class="dt-brand__logo-img" src="../assets/images/logoo.png" alt="Drift">
                            </a>
                        </div>
                    </div>
                    <!-- Login Content Section -->
                    <div class="dt-login__content">
                        <div class="dt-login__content-inner">
                            <!-- Form -->
                            <form action="login.php" method="POST" onsubmit="return validateForm()">
                                <!-- Form Group -->
                                <div class="form-group">
                                    <label class="sr-only" for="email-1">Account ID</label>
                                    <input type="text" class="form-control" id="email-1" name="login" aria-describedby="email-1" placeholder="Enter Admin ID">
                                </div>
                                <!-- Form Group -->
                                <div class="form-group">
                                    <label class="sr-only" for="password-1">Account Password</label>
                                    <input type="password" class="form-control" name="password" id="password-1" placeholder="Enter Admin Password">
                                </div>
                                <!-- Form Group -->
                                <div class="dt-checkbox d-block mb-6">
                                    <input type="checkbox" id="checkbox-1">
                                    <label class="dt-checkbox-content" for="checkbox-1">
                                        Keep me logged in on this device
                                    </label>
                                </div>
                                <!-- Form Group -->
                                <div class="form-group">
                                    <input type="submit" name="go" id="go" class="btn btn-primary text-uppercase" value="Login">
                                </div>
                            </form>
                        </div>
                        <!-- Login Content Footer -->
                        <div class="dt-login__content-footer">
                            <a href="../customer/login.php">Login as a user instead</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Optional JavaScript -->
    <script src="../assets/node_modules/jquery/dist/jquery.min.js"></script>
    <script src="../assets/node_modules/moment/moment.js"></script>
    <script src="../assets/node_modules/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/node_modules/perfect-scrollbar/dist/perfect-scrollbar.min.js"></script>
    <script src="../assets/node_modules/masonry-layout/dist/masonry.pkgd.min.js"></script>
    <script src="../assets/node_modules/sweetalert2/dist/sweetalert2.js"></script>
    <script src="../assets/js/functions.js"></script>
    <script src="../assets/js/customizer.js"></script>
    <script src="../assets/js/script.js"></script>
    <script src="../assets/js/custom/sweet-alert.js"></script>
    <script>
        function validateForm() {
            var username = document.getElementById('email-1').value;
            var password = document.getElementById('password-1').value;
            if (username === '' || password === '') {
                alert('Please fill in all fields.');
                return false;
            }
            return true;
        }
    </script>
</body>
</html>
<?php include 'footer.php'; ?>