<?php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
error_reporting(E_ALL); 
ini_set('display_errors', 1); 
include("../config/dbconfig.php");

if (!$con) {
    die("Connection failed: " . mysqli_connect_error());
}

if (!isset($_SESSION['adminid'])) {
    header("Location: login.php");
    exit();
}

$mail_count = 0;
if (isset($_SESSION['adminid'])) {
    $stmt = $con->prepare("SELECT COUNT(*) as count FROM mail WHERE reciverid = ? AND status = 'New'");
    if (!$stmt) {
        die("Prepare failed: " . $con->error);
    }
    $stmt->bind_param("s", $_SESSION['adminid']);
    $stmt->execute();
    $stmt->bind_result($mail_count);
    $stmt->fetch();
    $stmt->close();
} elseif (isset($_SESSION['customerid'])) {
    $stmt = $con->prepare("SELECT COUNT(*) as count FROM mail WHERE reciverid = ? AND status = 'New'");
    if (!$stmt) {
        die("Prepare failed: " . $con->error);
    }
    $stmt->bind_param("s", $_SESSION['customerid']);
    $stmt->execute();
    $stmt->bind_result($mail_count);
    $stmt->fetch();
    $stmt->close();
}

$messages = [];
if (isset($_SESSION['adminid']) || isset($_SESSION['customerid'])) {
    $reciverid = isset($_SESSION['adminid']) ? $_SESSION['adminid'] : $_SESSION['customerid'];
    $stmt = $con->prepare("SELECT mailid, senderid, subject, mdatetime FROM mail WHERE reciverid = ? AND status = 'New'");
    if (!$stmt) {
        die("Prepare failed: " . $con->error);
    }
    $stmt->bind_param("s", $reciverid);
    $stmt->execute();
    $stmt->bind_result($mailid, $senderid, $subject, $mdatetime);
    while ($stmt->fetch()) {
        $messages[] = [
            'mailid' => $mailid,
            'senderid' => $senderid,
            'subject' => $subject,
            'mdatetime' => $mdatetime
        ];
    }
    $stmt->close();
}

foreach ($messages as &$message) {
    $senderid = $message['senderid'];
    if ($senderid !== 'admin') {
        $stmt = $con->prepare("SELECT firstname, lastname FROM customers WHERE customerid = ?");
        if (!$stmt) {
            die("Prepare failed: " . $con->error);
        }
        $stmt->bind_param("s", $senderid);
        $stmt->execute();
        $stmt->bind_result($firstname, $lastname);
        if ($stmt->fetch()) {
            $message['sender_name'] = $firstname . " " . $lastname;
        } else {
            $message['sender_name'] = 'Unknown';
        }
        $stmt->close();
    } else {
        $message['sender_name'] = 'admin';
    }
}

$query = "SELECT currency, theme_color FROM system_settings";
$result = mysqli_query($con, $query);
if (!$result) {
    die("Query failed: " . mysqli_error($con));
}
$cur = '';
$color = 'light-style-1.min.css'; 
while ($row = mysqli_fetch_array($result)) {
    $cur = $row['currency'];
    $color = $row['theme_color'];
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="A digitalized banking software">
    <meta name="keywords" content="Ibank, piggybank">
    <title>Admin Dashboard</title>

    <!-- Site favicon -->
    <link rel="shortcut icon" href="../assets/images/favicon.ico" type="image/x-icon">
    <!-- Font Icon Styles -->
    <link rel="stylesheet" href="../assets/node_modules/flag-icon-css/css/flag-icon.min.css">
    <link rel="stylesheet" href="../assets/vendors/gaxon-icon/styles.css">
    <!-- Perfect Scrollbar stylesheet -->
    <link rel="stylesheet" href="../assets/node_modules/perfect-scrollbar/css/perfect-scrollbar.css">
    <!-- Load Styles -->
    <link rel="stylesheet" href="../assets/css/<?php echo htmlspecialchars($color); ?>">
    <link rel="stylesheet" href="../assets/css/style.min.css">
</head>
<body class="dt-sidebar--fixed dt-header--fixed">
    <!-- Loader -->
    <div class="dt-loader-container">
        <div class="dt-loader">
            <svg class="circular" viewBox="25 25 50 50">
                <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"></circle>
            </svg>
        </div>
    </div>
    <!-- Root -->
    <div class="dt-root">
        <div class="dt-root__inner">
            <!-- Header -->
            <header class="dt-header">
                <div class="dt-header__container">
                    <!-- Brand -->
                    <div class="dt-brand">
                        <div class="dt-brand__tool" data-toggle="main-sidebar">
                            <i style="color:white;" class="icon icon-apps icon-sm icon-fw"></i>
                        </div>
                        <span class="dt-brand__logo">
                            <a class="dt-brand__logo-link" href="login.php">
                                <img class="" width="50" height="40" src="../assets/images/logoo.png" alt="ibank">
                            </a>
                        </span>
                    </div>
                    <!-- Header toolbar -->
                    <div class="dt-header__toolbar">
                        <!-- Search box -->
                        <form class="search-box d-none d-lg-block" action="searchresult.php" method="get">
                            <div class="input-group">
                                <input class="form-control" name="query" placeholder="Enter Account Number or Date" type="search">
                                <span class="search-icon"><i class="icon icon-revenue icon-lg"></i></span>
                                <div class="input-group-append">
                                    <button class="btn btn-danger" type="submit"><i class="icon icon-search icon-lg"></i>Search</button>
                                </div>
                            </div>
                        </form>
                        <!-- Header Menu Wrapper -->
                        <div class="dt-nav-wrapper">
                            <!-- Header Menu -->
                            <ul class="dt-nav d-lg-none">
                                <li class="dt-nav__item dt-notification-search dropdown">
                                    <a href="#" class="dt-nav__link dropdown-toggle no-arrow" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <i style="color:white;" class="icon icon-search icon-fw icon-lg"></i>
                                    </a>
                                    <div class="dropdown-menu">
                                        <form class="search-box right-side-icon">
                                            <input class="form-control form-control-lg" name="query" type="search" placeholder="Enter Account Number or Date">
                                            <button type="submit" class="search-icon"><i class="icon icon-search icon-lg"></i></button>
                                        </form>
                                    </div>
                                </li>
                            </ul>
                            <!-- Header Menu -->
                            <ul class="dt-nav">
                                <li class="dt-nav__item dt-notification dropdown">
                                    <a href="#" class="dt-nav__link dropdown-toggle no-arrow" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <span style="color:white;">(<?php echo $mail_count; ?>)</span>
                                        <i style="color:white;" class="icon icon-open-mail icon-fw"></i>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right dropdown-menu-media">
                                        <div class="dropdown-menu-header">
                                            <h4 class="title">New Messages (<?php echo $mail_count; ?>)</h4>
                                        </div>
                                        <div class="dropdown-menu-body ps-custom-scrollbar">
                                            <div class="h-auto">
                                                <?php foreach ($messages as $row) { ?>
                                                    <!-- Media -->
                                                    <a href="readmessage.php?mailid=<?php echo htmlspecialchars($row['mailid']); ?>" class="media">
                                                        <!-- Avatar -->
                                                        <img class="dt-avatar mr-3" src="../assets/images/user-avatar/mathew.jpg" alt="User">
                                                        <!-- Media Body -->
                                                        <span class="media-body text-truncate">
                                                            <span class="user-name mb-1"><?php echo htmlspecialchars($row['sender_name']); ?></span>
                                                            <span class="message text-light-gray text-truncate"><?php echo htmlspecialchars($row['subject']); ?></span>
                                                        </span>
                                                        <!-- Action Area -->
                                                        <span class="action-area h-100 min-w-80 text-right">
                                                            <span class="meta-date mb-1"><?php echo htmlspecialchars($row['mdatetime']); ?></span>
                                                            <!-- Toggle Button -->
                                                            <span class="toggle-button" data-toggle="tooltip" data-placement="left" title="Mark as read">
                                                                <span class="show"><i class="icon icon-dot-o icon-fw f-10 text-light-gray"></i></span>
                                                                <span class="hide"><i class="icon icon-dot icon-fw f-10 text-light-gray"></i></span>
                                                            </span>
                                                        </span>
                                                    </a>
                                                    <!-- /media -->
                                                <?php } ?>
                                            </div>
                                        </div>
                                        <div class="dropdown-menu-footer">
                                            <a href="inbox.php" class="card-link">See All <i class="icon icon-arrow-right icon-fw"></i></a>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                            <!-- Header Menu -->
                            <ul class="dt-nav">
                                <li class="dt-nav__item dropdown">
                                    <a href="#" class="dt-nav__link dropdown-toggle no-arrow dt-avatar-wrapper" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <img class="" width="50" height="40" src="../assets/images/logoo.png" alt="ibank">
                                        <span class="dt-avatar-info d-none d-sm-block">
                                            <span style="color:white;" class="dt-avatar-name">Administrator</span>
                                        </span>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-right">
                                        <div class="dt-avatar-wrapper flex-nowrap p-6 mt--5 bg-gradient-purple text-white rounded-top">
                                            <img class="" width="50" height="40" src="../assets/images/logoo.png" alt="ibank">
                                            <span class="dt-avatar-info">
                                                <span class="dt-avatar-name">Administrator</span>
                                                <span class="f-12">Admin</span>
                                            </span>
                                        </div>
                                        <a class="dropdown-item" href="systemsettings.php"><i class="icon icon-settings icon-fw mr-2 mr-sm-1"></i>Setting</a>
                                        <a class="dropdown-item" href="logout.php"><i class="icon icon-logout icon-fw mr-2 mr-sm-1"></i>Logout</a>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </header>
            <!-- Site Main -->
            <main class="dt-main">
                <!-- Sidebar -->
                <aside id="main-sidebar" class="dt-sidebar">
                    <div class="dt-sidebar__container">
                        <!-- Sidebar Navigation -->
                        <ul class="dt-side-nav">
                            <!-- Menu Header -->
                            <li class="dt-side-nav__item dt-side-nav__header">
                                <span class="dt-side-nav__text">Admin Account</span>
                            </li>
                            <!-- Menu Item -->
                            <li class="dt-side-nav__item">
                                <a href="dashboard.php" class="dt-side-nav__link" title="Widgets">
                                    <i class="icon icon-menu icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Dashboard</span>
                                </a>
                            </li>
                            <!-- Menu Header -->
                            <li class="dt-side-nav__item dt-side-nav__header">
                                <span class="dt-side-nav__text">Customers</span>
                            </li>
                            <!-- Menu Item -->
                            <li class="dt-side-nav__item">
                                <a href="newaccount.php" class="dt-side-nav__link" title="Widgets">
                                    <i class="icon icon-user-account icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">New Customer</span>
                                </a>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="managecustomers.php" class="dt-side-nav__link" title="Widgets">
                                    <i class="icon icon-visits icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Manage Customers</span>
                                </a>
                            </li>
                            <!-- Menu Header -->
                            <li class="dt-side-nav__item dt-side-nav__header">
                                <span class="dt-side-nav__text">Transaction Management</span>
                            </li>
                            <!-- Menu Item -->
                            <li class="dt-side-nav__item">
                                <a href="javascript:void(0)" class="dt-side-nav__link dt-side-nav__arrow" title="Basic Components">
                                    <i class="icon icon-users icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Bank Transfers</span>
                                </a>
                                <!-- Sub-menu -->
                                <ul class="dt-side-nav__sub-menu">
                                    <li class="dt-side-nav__item">
                                        <a href="pendingtransfer.php" class="dt-side-nav__link" title="Alerts">
                                            <i class="icon icon-user-add icon-fw icon-lg"></i>
                                            <span class="dt-side-nav__text">Approve</span>
                                        </a>
                                    </li>
                                    <li class="dt-side-nav__item">
                                        <a href="viewalltransfers.php" class="dt-side-nav__link" title="Badges">
                                            <i class="icon icon-user-account icon-fw icon-lg"></i>
                                            <span class="dt-side-nav__text">View All</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <!-- Menu Header -->
                            <li class="dt-side-nav__item dt-side-nav__header">
                                <span class="dt-side-nav__text">Savings Management</span>
                            </li>
                            <!-- Menu Item -->
                            <li class="dt-side-nav__item">
                                <a href="debitcutomer.php" class="dt-side-nav__link" title="Basic Form">
                                    <i class="icon icon-dollar-circle icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Debit Account</span>
                                </a>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="creditcutomer.php" class="dt-side-nav__link" title="Basic Form">
                                    <i class="icon icon-forms-basic icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Credit Account</span>
                                </a>
                            </li>
                            <!-- Menu Item -->
                            <li class="dt-side-nav__item">
                                <a href="javascript:void(0)" class="dt-side-nav__link dt-side-nav__arrow" title="Basic Components">
                                    <i class="icon icon-users icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">History</span>
                                </a>
                                <!-- Sub-menu -->
                                <ul class="dt-side-nav__sub-menu">
                                    <li class="dt-side-nav__item">
                                        <a href="credithistory.php" class="dt-side-nav__link" title="Alerts">
                                            <i class="icon icon-user-add icon-fw icon-lg"></i>
                                            <span class="dt-side-nav__text">Credit History</span>
                                        </a>
                                    </li>
                                    <li class="dt-side-nav__item">
                                        <a href="debithistory.php" class="dt-side-nav__link" title="Badges">
                                            <i class="icon icon-user-account icon-fw icon-lg"></i>
                                            <span class="dt-side-nav__text">Debit History</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <!-- Menu Header -->
                            <li class="dt-side-nav__item dt-side-nav__header">
                                <span class="dt-side-nav__text">Loan Management</span>
                            </li>
                            <!-- Menu Item -->
                            <li class="dt-side-nav__item">
                                <a href="newloan.php" class="dt-side-nav__link" title="Basic Form">
                                    <i class="icon icon-timer icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">New Loan Plan</span>
                                </a>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="viewloan.php" class="dt-side-nav__link" title="File Upload">
                                    <i class="icon icon-file-upload icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Edit Loan Plan</span>
                                </a>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="loanapplications.php" class="dt-side-nav__link" title="File Upload">
                                    <i class="icon icon-dollar icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Loan Applications</span>
                                </a>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="disburse.php" class="dt-side-nav__link" title="File Upload">
                                    <i class="icon icon-dollar icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Disburse Loan</span>
                                </a>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="loanpayhistory.php" class="dt-side-nav__link" title="File Upload">
                                    <i class="icon icon-file-upload icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Payment History</span>
                                </a>
                            </li>
                            <!-- Menu Header -->
                            <li class="dt-side-nav__item dt-side-nav__header">
                                <span class="dt-side-nav__text">Messages</span>
                            </li>
                            <!-- Menu Item -->
                            <li class="dt-side-nav__item">
                                <a href="inbox.php" class="dt-side-nav__link" title="Notifications">
                                    <i class="icon icon-mail icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">New Message (<?php echo $mail_count; ?>)</span>
                                </a>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="sent.php" class="dt-side-nav__link" title="Drag & Drop">
                                    <i class="icon icon-send icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Sent Messages</span>
                                </a>
                            </li>
                            <!-- Menu Header -->
                            <li class="dt-side-nav__item dt-side-nav__header">
                                <span class="dt-side-nav__text">Staff Management</span>
                            </li>
                            <!-- Menu Item -->
                            <li class="dt-side-nav__item">
                                <a href="newstaff.php" class="dt-side-nav__link" title="Notifications">
                                    <i class="icon icon-mail icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Create Employee Account</span>
                                </a>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="managestaff.php" class="dt-side-nav__link" title="Drag & Drop">
                                    <i class="icon icon-send icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Manage Employee Account</span>
                                </a>
                            </li>
                            <!-- Menu Header -->
                            <li class="dt-side-nav__item dt-side-nav__header">
                                <span class="dt-side-nav__text">Settings</span>
                            </li>
                            <!-- Menu Item -->
                            <li class="dt-side-nav__item">
                                <a href="systemsettings.php" class="dt-side-nav__link" title="Notifications">
                                    <i class="icon icon-settings icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">System Settings</span>
                                </a>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="manageaccount.php" class="dt-side-nav__link" title="Notifications">
                                    <i class="icon icon-settings icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Account Type Settings</span>
                                </a>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="javascript:void(0)" class="dt-side-nav__link dt-side-nav__arrow" title="Basic Components">
                                    <i class="icon icon-users icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Branch Settings</span>
                                </a>
                                <!-- Sub-menu -->
                                <ul class="dt-side-nav__sub-menu">
                                    <li class="dt-side-nav__item">
                                        <a href="createbranch.php" class="dt-side-nav__link" title="Alerts">
                                            <i class="icon icon-user-add icon-fw icon-lg"></i>
                                            <span class="dt-side-nav__text">Create Branch</span>
                                        </a>
                                    </li>
                                    <li class="dt-side-nav__item">
                                        <a href="managebranch.php" class="dt-side-nav__link" title="Badges">
                                            <i class="icon icon-user-account icon-fw icon-lg"></i>
                                            <span class="dt-side-nav__text">Manage Branch</span>
                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="adminpass.php" class="dt-side-nav__link" title="Drag & Drop">
                                    <i class="icon icon-send icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Admin Password</span>
                                </a>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="paymentgateway.php" class="dt-side-nav__link" title="Drag & Drop">
                                    <i class="icon icon-send icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Payment Gateway Settings</span>
                                </a>
                            </li>
                            <!-- Menu Header -->
                            <li class="dt-side-nav__item dt-side-nav__header">
                                <span class="dt-side-nav__text">Logout</span>
                            </li>
                            <li class="dt-side-nav__item">
                                <a href="logout.php" class="dt-side-nav__link" title="Drag & Drop">
                                    <i class="icon icon-logout icon-fw icon-lg"></i>
                                    <span class="dt-side-nav__text">Logout</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </aside>
                <!-- /sidebar -->